class Mutator_Inventory expands Mutator;

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	if ((Other.IsA('Health_HealthPack')) || (Other.IsA('Health_HealthVial')) || (Other.IsA('Health_MedBox')) || (Other.IsA('Pickup_ShieldBelt')) || (Other.IsA('Pickup_ThighPads')) || (Other.IsA('Pickup_Armor2')))
		{
		Return True;
		}
	else if (Other.IsA('HealthPack'))
		{
		ReplaceWith(Other,"InstantAction.Health_HealthPack");
		return false;
		}
	else if (Other.IsA('HealthVial'))
		{
		ReplaceWith(Other,"InstantAction.Health_HealthVial");
		return false;
		}
	else if (Other.IsA('MedBox'))
		{
		ReplaceWith(Other,"InstantAction.Health_MedBox");
		return false;
		}
	else if (Other.IsA('UT_ShieldBelt'))
		{
		ReplaceWith(Other,"InstantAction.Pickup_ShieldBelt");
		return false;
		}
	else if (Other.IsA('ThighPads'))
		{
		ReplaceWith(Other,"InstantAction.Pickup_ThighPads");
		return false;
		}
	else if (Other.IsA('Armor2'))
		{
		ReplaceWith(Other,"InstantAction.Pickup_Armor2");
		return false;
		}
	else if (Other.IsA('WarheadLauncher'))
		{
		return False;
		}
	return true;
}

function bool AlwaysKeep(Actor Other)
{
	if (Other.IsA('TournamentAmmo'))
		{
		TournamentAmmo(Other).AmmoAmount = 50;
		TournamentAmmo(Other).MaxAmmo = 1000;
		}
	if (Other.IsA('TournamentWeapon'))
		{
		TournamentWeapon(Other).PickupAmmoCount = 50;
		}
		
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{
		if (inv.IsA('Weapon') && !inv.IsA('ImpactHammer'))
			{
			weap = Weapon(inv);

			//spawn inventory item to world:
			dropped = Spawn(weap.Class,,,Killed.Location);

			speed = VSize(Killed.Velocity);

			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);

			weap = Weapon(dropped);

			weap.PickupAmmoCount = Rand(100);

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			else if (Ammo(inv) == None)
				{
				dropped = Spawn(inv.Class,,,Killed.Location);
				inv = Inventory(dropped);
				inv.Charge = Rand(100);
				if (inv != None)
					{
					inv.RespawnTime = 0.0;
					inv.BecomePickup();
					}
				}
			}
		Killed.Inventory.Destroy();
		}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}


